/*****************************************************************
;*        Sample SFR/Vector File for TLCS-870/C1 Series          *
;*               Memory Style: Within 64K byte                   *
;*---------------------------------------------------------------*
;*  (C)Copyright TOSHIBA CORPORATION 2008  All rights reserved   *
;*****************************************************************/

#include "MQ6905.h"



void startup(void);	//defined by startup.asm
/*========================================================
  [ Declare interrupt function ]
  ========================================================*/
void __interrupt Int0(void);
void __interrupt Int1(void);
void __interrupt Int2(void);
void __interrupt Int3(void);
void __interrupt Int4(void);
void __interrupt Int5(void);
void __interrupt IntTC00(void);
void __interrupt IntTC01(void);
void __interrupt IntTC02(void);
void __interrupt IntTC03(void);
void __interrupt IntTCC0T(void);
void __interrupt IntTCC0P(void);
void __interrupt IntTEMG0(void);
void __interrupt IntTCA0(void);
void __interrupt IntTCA1(void);
void __interrupt IntSBI0_SIO0(void);
void __interrupt IntRTC(void);
void __interrupt IntADC(void);
void __interrupt IntVLTD(void);
void __interrupt IntRXD0_SIO0(void);
void __interrupt IntTXD0(void);
void __interrupt IntRXD1(void);
void __interrupt IntTXD1(void);
void __interrupt IntRXD2(void);
void __interrupt IntTXD2(void);
void __interrupt IntTBT(void);
void __interrupt IntWUC(void);
void __interrupt_n IntWDT(void);
void __interrupt_n IntSWI(void);


/*========================================================
  [ Dummy function for interrupt ]
  ========================================================*/
void __interrupt		Int_dummy(void){ }
void __interrupt_n		Int_n_dummy(void){ }

/*========================================================
  [ Implement interrupt function]
  ========================================================*/

//----------<External interrupt	routine>
void __interrupt Int0(void)
{
	//Add your interrupt handler code here
}
void __interrupt Int1(void)
{
	//Add your interrupt handler code here
}
void __interrupt Int2(void)
{
	//Add your interrupt handler code here
}
void __interrupt Int3(void)
{
	//Add your interrupt handler code here
}
void __interrupt Int4(void)
{
	//Add your interrupt handler code here
}
void __interrupt Int5(void)
{
	//Add your interrupt handler code here
}

//----------<8 bit timer counter interrupt routine>
void __interrupt IntTC00(void)
{
	//Add your interrupt handler code here
	P0DR.bit.b0 = ~P0DR.bit.b0;
}
void __interrupt IntTC01(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTC02(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTC03(void)
{
	//Add your interrupt handler code here
}

//----------<16 bit timer counter interrupt routine>
void __interrupt IntTCA0(void)
{
	//Add your interrupt handler code here
}

//----------<10 bit timer TCC series interrupt routine>
void __interrupt IntTCC0T(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTCC0P(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTEMG0(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTCA1(void)
{
	//Add your interrupt handler code here
}

//----------<Serial Bus/Synchronous Serial interrupt routine>
void __interrupt IntSBI0_SIO0(void)
{
	//Add your interrupt handler code here
}

//----------<Real time clock interrupt routine>
void __interrupt IntRTC(void)
{
	//Add your interrupt handler code here
}

//----------<A/D converter interrupt routine>
void __interrupt IntADC(void)
{
	//Add your interrupt handler code here
}

//----------<Voltage Detect interrupt routine>
void __interrupt IntVLTD(void)
{
	//Add your interrupt handler code here
}

//----------<Asynchronous/Synchronous Serial interrupt routine>
void __interrupt IntRXD0_SIO0(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTXD0(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntRXD1(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTXD1(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntRXD2(void)
{
	//Add your interrupt handler code here
}
void __interrupt IntTXD2(void)
{
	//Add your interrupt handler code here
}

//----------<Time base timer interrupt routine>
void __interrupt IntTBT(void)
{
	//Add your interrupt handler code here
}

//----------<Warm-up counter interrupt routine>
void __interrupt IntWUC(void)
{
	//Add your interrupt handler code here
}

//----------<Watch dog timer interrupt routine>
void __interrupt_n IntWDT(void)
{
	//Add your interrupt handler code here
}

//----------<Software interrupt routine>
void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };		

    for( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2.byte=0x10; 	//system clock reset
    }

    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");	
}      
/*============================================
  [ Define interrupt table ]
    This part must be rewrite.
  ============================================*/
#pragma section const INT_VECTOR1
void * const IntTbl1[] = {
    IntTCC0T,			/* 0xffc2 : IntTCC0T */
	IntTCC0P,			/* 0xffc4 : IntTCC0P */
	IntTEMG0,			/* 0xffc6 : IntTEMG0 */
	IntTXD2,			/* 0xffc8 : IntTXD2 */
	IntRXD2,			/* 0xffca : IntRXD2 */
	IntTC03,			/* 0xffcc : IntTC03 */
    IntTC02,			/* 0xffce : IntTC02 */
    IntTXD1,			/* 0xffd0 : IntTXD1 */
    IntRXD1,			/* 0xffd2 : IntRXD1 */
    IntTCA1,			/* 0xffd4 : IntTCA1 */
    Int4,				/* 0xffd6 : Int4 */
    Int3,				/* 0xffd8 : Int3 */
    Int2,				/* 0xffda : Int2 */
    Int1,				/* 0xffdc : Int1 */
    Int0,				/* 0xffde : Int0 */
    IntSBI0_SIO0,		/* 0xffe0 : IntSBI0_SIO0 */
    IntTCA0,			/* 0xffe2 : IntTCA0  */
    IntTC01,			/* 0xffe4 : IntTC01 */
    IntTC00,			/* 0xffe6 : IntTC00 */
    IntRTC,				/* 0xffe8 : IntRTC */
    IntADC,				/* 0xffea : IntADC */
    IntVLTD,			/* 0xffec : IntVLTD */
    Int5,				/* 0xffee : Int5 */
    IntTXD0,			/* 0xfff0 : IntTXD0 */
    IntRXD0_SIO0,		/* 0xfff2 : IntRXD0_SIO0 */
    IntTBT,				/* 0xfff4 : IntTBT */
    IntWUC,	    		/* 0xfff6 : IntWUC */
    IntWDT,				/* 0xfff8 : IntWDT */
    (void *)0xffff,		/* 0xfffa : Reserved */
    IntSWI,	   			/* 0xfffc : IntSWI/INTUNDEF */
    startup		    	/* 0xfffe : RESET */
};
#pragma section const   /* return to default */
